function RNLTV_inpainting_Fig10_checkerboard
% 090332017 checkerboard synLines332412281
%
%setup the path
curDir=pwd; %Identify current folder

addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

application.name = 'inpainting';

ExpFolderName = 'results';
patialMaskName = 'checkerboard';
imgResultFolder = ['' patialMaskName];

ExpFolderPath = strjoin({curDir,ExpFolderName,application.name,imgResultFolder},filesep);
if ~exist(ExpFolderPath , 'dir')
    mkdir(ExpFolderPath );
end

fileName_array = {'Fig10' };

nbIter = 3000;
radius = 5;
init = 9;

application.data_term = 2;

gama = 3;
lambda  = 5000;
mu=0.8;
hsigma=0.03;

for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    ExpSubfolderPath = strjoin({ExpFolderPath,fileName},filesep);
    if ~exist( ExpSubfolderPath, 'dir')
        mkdir( ExpSubfolderPath);
    end
    
    load([fileName,'.mat']);
    miss_data = imread([patialMaskName,'_miss_data.png']);
    miss_data = double(miss_data)/ 255;
    
    in_polluted = in_clean.*miss_data;
    
    application.miss_data = miss_data;
    rng(8,'twister');
    
    [u,v,energies] = regularized_NLTV(in_polluted,nbIter,radius,mu,...
        lambda,gama, hsigma, init, application);
    psnr = psnr1(u,in_clean)
    
    imgResultNameFolderPath = strjoin({ExpSubfolderPath,...
        [fileName,'_',patialMaskName]},filesep);
    
    % save image results
    save([imgResultNameFolderPath '_u_.mat'],'u');
end